<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', __('Wishlist'));
?>

<section class="tp-wishlist-area <?php if(! theme_option('theme_breadcrumb_enabled', true)): ?> pt-50 <?php endif; ?>">
    <div class="container">
        <?php if($products->total() && $products->loadMissing(['options', 'options.values'])): ?>
            <div class="tp-cart-list mb-45">
                <table class="table">
                    <thead>
                    <tr>
                        <th colspan="2" class="tp-cart-header-product"><?php echo e(__('Product')); ?></th>
                        <th class="tp-cart-header-price"><?php echo e(__('Price')); ?></th>
                        <th class="tp-cart-header-quantity"><?php echo e(__('Quantity')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="tp-cart-img">
                                <a href="<?php echo e($product->original_product->url); ?>">
                                    <?php echo e(RvMedia::image($product->image, $product->name, 'thumb')); ?>

                                </a>
                            </td>
                            <td class="ps-3">
                                <div class="tp-cart-title">
                                    <a href="<?php echo e($product->original_product->url); ?>" class="ms-0">
                                        <?php echo e($product->name); ?>


                                        <span class="small">
                                            (<?php echo $product->stock_status_html; ?>)
                                        </span>
                                    </a>
                                </div>

                                <?php if(is_plugin_active('marketplace') && $product->original_product->store->id): ?>
                                    <div class="small">
                                        <span><?php echo e(__('Vendor:')); ?></span>
                                        <a href="<?php echo e($product->original_product->store->url); ?>" class="fw-medium"><?php echo e($product->original_product->store->name); ?></a>
                                    </div>
                                <?php endif; ?>

                                <?php if($product->sku): ?>
                                    <div class="small">
                                        <span><?php echo e(__('SKU:')); ?></span>
                                        <span><?php echo e($product->sku); ?></span>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="tp-cart-price">
                                <?php echo $__env->make(EcommerceHelper::viewPath('includes.product-price'), [
                                    'priceWrapperClassName' => '',
                                    'priceClassName' => '',
                                    'priceOriginalWrapperClassName' => '',
                                    'priceOriginalClassName' => 'text-muted',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </td>

                            <td class="tp-cart-quantity">
                                <div class="tp-product-quantity mt-10 mb-10">
                                    <span class="tp-cart-minus" data-bb-toggle="decrease-qty">
                                        <svg width="10" height="2" viewBox="0 0 10 2" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 1H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                    <input
                                        class="tp-cart-input"
                                        type="number"
                                        name="qty"
                                        value="<?php echo e($product->min_cart_quantity); ?>"
                                        min="<?php echo e($product->min_cart_quantity); ?>"
                                        max="<?php echo e($product->max_cart_quantity); ?>"
                                    />
                                    <span class="tp-cart-plus" data-bb-toggle="increase-qty">
                                        <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5 1V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M1 5H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                </div>
                            </td>

                            <td class="tp-cart-add-to-cart">
                                <button
                                    type="submit"
                                    class="tp-btn tp-btn-2 tp-btn-blue"
                                    data-bb-toggle="add-to-cart"
                                    data-show-toast-on-success="false"
                                    data-url="<?php echo e(route('public.cart.add-to-cart')); ?>"
                                    data-id="<?php echo e($product->original_product->id); ?>"
                                    <?php echo EcommerceHelper::jsAttributes('add-to-cart', $product); ?>

                                >
                                    <?php echo e(__('Add To Cart')); ?>

                                </button>
                            </td>

                            <?php if($canRemoveWishlist): ?>
                                <td class="tp-cart-action">
                                    <button class="tp-cart-action-btn" data-bb-toggle="remove-from-wishlist" data-url="<?php echo e(route('public.wishlist.remove', $product)); ?>">
                                        <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                fill-rule="evenodd"
                                                clip-rule="evenodd"
                                                d="M9.53033 1.53033C9.82322 1.23744 9.82322 0.762563 9.53033 0.46967C9.23744 0.176777 8.76256 0.176777 8.46967 0.46967L5 3.93934L1.53033 0.46967C1.23744 0.176777 0.762563 0.176777 0.46967 0.46967C0.176777 0.762563 0.176777 1.23744 0.46967 1.53033L3.93934 5L0.46967 8.46967C0.176777 8.76256 0.176777 9.23744 0.46967 9.53033C0.762563 9.82322 1.23744 9.82322 1.53033 9.53033L5 6.06066L8.46967 9.53033C8.76256 9.82322 9.23744 9.82322 9.53033 9.53033C9.82322 9.23744 9.82322 8.76256 9.53033 8.46967L6.06066 5L9.53033 1.53033Z"
                                                fill="currentColor"
                                            />
                                        </svg>
                                        <span><?php echo e(__('Remove')); ?></span>
                                    </button>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="tp-cart-bottom">
                <div class="d-flex flex-wrap gap-4 align-items-center justify-content-between">
                    <div class="tp-cart-update">
                        <a href="<?php echo e(route('public.cart')); ?>" class="tp-cart-update-btn"><?php echo e(__('Go To Cart')); ?></a>
                    </div>
                    <?php if(EcommerceHelper::isWishlistSharingEnabled()): ?>
                        <div>
                            <span class="d-inline-block me-1"><?php echo e(__('Share:')); ?></span>

                            <?php echo Theme::renderSocialSharing(route('public.wishlist', ['code' => EcommerceHelper::getWishlistCode()])); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="text-center pt-50">
                <h3><?php echo e(__('Your wishlist is empty')); ?></h3>
                <a href="<?php echo e(route('public.products')); ?>" class="tp-cart-checkout-btn mt-20"><?php echo e(__('Continue Shopping')); ?></a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php /**PATH /home/jeffacomputersco/public_html/platform/themes/shofy/views/ecommerce/wishlist.blade.php ENDPATH**/ ?>