<?php
    $dataForFilter = EcommerceHelper::dataForFilter($category ?? null, $request ?? null);
    [$categories, $brands, $tags, $rand, $categoriesRequest, $urlCurrent, $categoryId, $maxFilterPrice] = $dataForFilter;
?>

<div class="bb-shop-sidebar">
    <form action="<?php echo e(URL::current()); ?>" data-action="<?php echo e(route('public.products')); ?>" method="GET" class="bb-product-form-filter">
        <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.filter-hidden-fields'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo apply_filters('theme_ecommerce_products_filter_before', null, $dataForFilter); ?>


        <?php if(EcommerceHelper::isEnabledFilterProductsByCategories()): ?>
            <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.categories'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(EcommerceHelper::isEnabledFilterProductsByBrands()): ?>
            <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.brands'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(EcommerceHelper::isEnabledFilterProductsByTags()): ?>
            <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.tags'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(EcommerceHelper::isEnabledFilterProductsByPrice() && (! EcommerceHelper::hideProductPrice() || EcommerceHelper::isCartEnabled())): ?>
            <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.price'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(EcommerceHelper::isEnabledFilterProductsByAttributes()): ?>
            <?php echo $__env->make(EcommerceHelper::viewPath('includes.filters.attributes', ['view' => $view ?? null]), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php echo apply_filters('theme_ecommerce_products_filter_after', null, $dataForFilter); ?>

    </form>
</div>
<?php /**PATH /home/janahcosmetico/public_html/platform/plugins/ecommerce/resources/views/themes/includes/filters.blade.php ENDPATH**/ ?>