<?php
    Theme::layout('full-width');
    Theme::set('breadcrumbStyle', 'without-title');

    $relatedPosts = get_related_posts($post->getKey(), 3);
    Theme::set('pageTitle', $post->name);

    $blogSidebar = dynamic_sidebar('blog_sidebar');

?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tp-postbox-details-area', 'pb-120' => $relatedPosts->isEmpty(),  'pt-50' => ! theme_option('theme_breadcrumb_enabled', true)]); ?>">
    <?php echo apply_filters('ads_render', null, 'detail_page_before'); ?>


    <div class="container">
        <div class="row">
            <div class="col-xl-9">
                <div class="tp-postbox-details-top">
                    <?php if($post->categories->isNotEmpty()): ?>
                        <div class="tp-postbox-details-category">
                            <?php $__currentLoopData = $post->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span>
                                    <a href="<?php echo e($category->url); ?>" title="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                    <h1 class="tp-postbox-details-title"><?php echo e($post->name); ?></h1>
                    <div class="tp-postbox-details-meta mb-50">
                        <?php if($post->author): ?>
                            <span data-meta="author">
                                <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-user'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                <?php echo e(__('By :name', ['name' => $post->author->name])); ?>

                            </span>
                        <?php endif; ?>
                        <span>
                            <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-clock'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                            <?php echo e(Theme::formatDate($post->created_at)); ?>

                        </span>
                        <span>
                            <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-eye'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                            <?php echo e(number_format($post->views)); ?>

                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['col-xl-9 col-lg-8' => $blogSidebar, 'col-12' => ! $blogSidebar]); ?>">
                <div class="tp-postbox-details-main-wrapper">
                    <div class="tp-postbox-details-content">
                        <div class="ck-content"><?php echo BaseHelper::clean($post->content); ?></div>

                        <div class="tp-postbox-details-share-wrapper">
                            <div class="row">
                                <div class="col-12">
                                    <?php if($post->tags->isNotEmpty()): ?>
                                        <div class="tp-postbox-details-tags tagcloud">
                                            <span><?php echo e(__('Tags:')); ?></span>
                                            <?php $__currentLoopData = $post->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e($tag->url); ?>"><?php echo e($tag->name); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="tp-product-details-social mt-10">
                                        <span><?php echo e(__('Share:')); ?></span>
                                        <?php echo Theme::renderSocialSharing($post->url, SeoHelper::getDescription(), $post->image); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $post); ?>

                    </div>
                </div>
            </div>
            <?php if($blogSidebar): ?>
                <div class="col-xl-3 col-lg-4">
                    <div class="tp-sidebar-wrapper tp-sidebar-ml--24">
                        <?php echo $blogSidebar; ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if($relatedPosts->isNotEmpty()): ?>
        <div class="tp-postbox-related-area pt-115 pb-50 mt-50" style="background-color: #F4F7F9">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="tp-postbox-related">
                            <h3 class="tp-postbox-related-title"><?php echo e(__('Related Articles')); ?></h3>

                            <div class="row">
                                <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-lg-4">
                                        <?php echo $__env->make(Theme::getThemeNamespace('views.partials.post-grid-item'), ['post' => $relatedPost, 'class' => 'tp-blog-grid-style2'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php echo apply_filters('ads_render', null, 'detail_page_after'); ?>

</section>
<?php /**PATH /home/jeffacomputersco/dev.jeffacomputers.com/platform/themes/shofy/views/post.blade.php ENDPATH**/ ?>