<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', __('Compare'));
?>

<section class="tp-compare-area <?php if(! theme_option('theme_breadcrumb_enabled', true)): ?> pt-50 <?php endif; ?>">
    <div class="container">
        <?php if($products->isNotEmpty()): ?>
            <div class="tp-compare-table table-responsive text-center">
                <table class="table">
                    <tbody>
                    <tr>
                        <th><?php echo e(__('Product')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div class="tp-compare-thumb">
                                    <?php echo e(RvMedia::image($product->image, $product->name, 'thumb')); ?>

                                    <h4 class="tp-compare-product-title">
                                        <a href="<?php echo e($product->url); ?>"><?php echo e($product->name); ?></a>
                                    </h4>

                                    <?php echo $product->stock_status_html; ?>

                                </div>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th><?php echo e(__('Description')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div class="tp-compare-desc">
                                    <?php echo BaseHelper::clean($product->description); ?>

                                </div>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th><?php echo e(__('Price')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php echo $__env->make(EcommerceHelper::viewPath('includes.product-price'), [
                                    'priceWrapperClassName' => 'tp-compare-price',
                                    'priceClassName' => '',
                                    'priceOriginalWrapperClassName' => '',
                                    'priceOriginalClassName' => 'old-price',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th><?php echo e(__('SKU')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($product->sku ? '#' . $product->sku : ''); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <?php $__currentLoopData = $attributeSets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributeSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(! $attributeSet->is_comparable) continue; ?>

                        <tr>
                            <th><?php echo e($attributeSet->title); ?></th>

                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <?php echo e(render_product_attributes_view_only($product, $attributeSet)); ?>

                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th><?php echo e(__('Add to cart')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div class="tp-compare-add-to-cart">
                                    <button
                                        type="submit"
                                        class="tp-btn"
                                        data-bb-toggle="add-to-cart"
                                        data-show-toast-on-success="false"
                                        data-url="<?php echo e(route('public.cart.add-to-cart')); ?>"
                                        data-id="<?php echo e($product->original_product->id); ?>"
                                        <?php echo EcommerceHelper::jsAttributes('add-to-cart', $product); ?>

                                    ><?php echo e(__('Add to Cart')); ?></button>
                                </div>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th><?php echo e(__('Rating')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div class="tp-compare-rating">
                                    <?php echo $__env->make(EcommerceHelper::viewPath('includes.rating-star'), ['avg' => $product->reviews_avg, 'size' => 80], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th><?php echo e(__('Remove')); ?></th>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <div class="tp-compare-remove">
                                    <button data-bb-toggle="remove-from-compare" data-url="<?php echo e(route('public.compare.remove', $product->id)); ?>">
                                        <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-trash'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                    </button>
                                </div>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center pt-50">
                <h3><?php echo e(__('Your compare list is empty')); ?></h3>
                <a href="<?php echo e(route('public.products')); ?>" class="tp-cart-checkout-btn mt-20"><?php echo e(__('Continue Shopping')); ?></a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php /**PATH /home/janahcosmetico/public_html/platform/themes/shofy/views/ecommerce/compare.blade.php ENDPATH**/ ?>