<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', $gallery->name);
?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['pb-100',  'pt-50' => ! theme_option('theme_breadcrumb_enabled', true)]); ?>">
    <div class="container">
        <div>
            <?php echo BaseHelper::clean($gallery->description); ?>

        </div>
        <div class="row row-cols-4 g-3" id="list-photo">
            <?php $__currentLoopData = gallery_meta_data($gallery); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(! $image) continue; ?>

                <div data-src="<?php echo e(RvMedia::getImageUrl($imageUrl = Arr::get($image, 'img'))); ?>" data-sub-html="<?php echo e($description = BaseHelper::clean(Arr::get($image, 'description'))); ?>">
                    <a href="<?php echo e($description); ?>">
                        <?php echo e(RvMedia::image($imageUrl, $description, attributes: ['class' => 'rounded-3 w-100'])); ?>

                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $gallery); ?>

    </div>
</section>
<?php /**PATH C:\laragon\www\Jeffa\platform\themes/shofy/views/gallery.blade.php ENDPATH**/ ?>