<?php
    $title = $shortcode->title;
    $subtitle = $shortcode->subtitle;
    $buttonLabel = $shortcode->button_label;
    $buttonUrl = $shortcode->button_url;
?>

<section class="tp-category-area pt-50"
     <?php if($shortcode->background_color): ?>
         style="background-color: <?php echo e($shortcode->background_color); ?> !important;"
    <?php endif; ?>
>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-8">
                <?php echo Theme::partial('section-title', compact('shortcode')); ?>

            </div>

            <?php if($buttonLabel && $buttonUrl): ?>
                <div class="col-lg-6 col-md-4">
                    <div class="tp-category-more-3 text-md-end mb-55">
                        <a href="<?php echo e($buttonUrl); ?>" class="tp-btn">
                            <?php echo e($buttonLabel); ?>

                            <svg width="12" height="10" viewBox="0 0 12 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.9994 4.99981L1.04004 4.99981" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M6.98291 1L10.9998 4.99967L6.98291 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-sm-6">
                    <div class="tp-category-item-3 p-relative grey-bg text-center z-index-1 fix mb-30">
                        <div
                            class="tp-category-thumb-3 include-bg"
                            <?php if($category->image): ?>
                                data-background="<?php echo e(RvMedia::getImageUrl($category->image)); ?>"
                            <?php endif; ?>
                        ></div>
                        <div class="tp-category-content-3 transition-3">
                            <h3 class="tp-category-title-3">
                                <a href="<?php echo e($category->url); ?>" title="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></a>
                            </h3>
                            <?php if($shortcode->show_products_count): ?>
                                <span class="tp-categroy-ammount-3">
                                    <?php if($category->count_all_products === 1): ?>
                                        <?php echo e(__('1 product')); ?>

                                    <?php else: ?>
                                        <?php echo e(__(':count products', ['count' => number_format($category->count_all_products)])); ?>

                                    <?php endif; ?>
                                </span>
                            <?php endif; ?>
                            <?php if($shortcode->button_view_more_label): ?>
                                <div class="tp-category-btn-3">
                                    <a href="<?php echo e($category->url); ?>" class="tp-link-btn tp-link-btn-2">
                                        <?php echo e($shortcode->button_view_more_label); ?>

                                        <svg width="7" height="12" viewBox="0 0 7 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 1L6.02116 5.99958L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH C:\laragon\www\Jeffa\platform\themes/shofy-beauty/partials/shortcodes/ecommerce-categories/grid.blade.php ENDPATH**/ ?>