<?php
    Theme::set('pageTitle', $page->name);

    if ($breadcrumbStyle = $page->getMetaData('breadcrumb_style', true)) {
        Theme::set('breadcrumbStyle', $breadcrumbStyle);
    }

    if ($breadcrumbBackground = $page->getMetaData('breadcrumb_background', true)) {
        Theme::set('breadcrumbBackground', $breadcrumbBackground);
    }

    Theme::set('isHomePage', BaseHelper::isHomePage($page->id));
?>

<?php if(BaseHelper::isHomepage($page->id)): ?>
    <?php echo apply_filters(PAGE_FILTER_FRONT_PAGE_CONTENT, BaseHelper::clean($page->content), $page); ?>

<?php else: ?>
    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['pt-50' => ! theme_option('theme_breadcrumb_enabled', true)]); ?>">
        <div class="ck-content">
            <?php echo apply_filters(PAGE_FILTER_FRONT_PAGE_CONTENT, BaseHelper::clean($page->content), $page); ?>

        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/jeffacomputersco/dev.jeffacomputers.com/platform/themes/shofy/views/page.blade.php ENDPATH**/ ?>