<?php if(Cart::instance('cart')->isNotEmpty() && Cart::instance('cart')->products()->count()): ?>
    <div class="cartmini__checkout">
        <div class="d-flex flex-column gap-2 cartmini__checkout-title mb-30">
            <div>
                <h4><?php echo e(__('Subtotal:')); ?></h4>
                <span><?php echo e(format_price(Cart::instance('cart')->rawSubTotal())); ?></span>
            </div>
            <?php if(EcommerceHelper::isTaxEnabled()): ?>
                <div>
                    <h4><?php echo e(__('Tax:')); ?></h4>
                    <span><?php echo e(format_price(Cart::instance('cart')->rawTax())); ?></span>
                </div>
                <div>
                    <h4><?php echo e(__('Total:')); ?></h4>
                    <span><?php echo e(format_price(Cart::instance('cart')->rawSubTotal() + Cart::instance('cart')->rawTax())); ?></span>
                </div>
            <?php endif; ?>
        </div>
        <div class="cartmini__checkout-btn">
            <?php if(session('tracked_start_checkout')): ?>
                <a href="<?php echo e(route('public.checkout.information', session('tracked_start_checkout'))); ?>" class="mb-10 tp-btn w-100">
                    <?php echo e(__('Checkout')); ?>

                </a>
            <?php endif; ?>

            <a href="<?php echo e(route('public.cart')); ?>" class="tp-btn tp-btn-border w-100">
                <?php echo e(__('View Cart')); ?>

            </a>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/jeffacomputersco/public_html/platform/themes/shofy/partials/mini-cart/footer.blade.php ENDPATH**/ ?>