<?php $__env->startSection('title', SeoHelper::getTitle()); ?>

<?php $__env->startSection('content'); ?>
    <?php if($products->isNotEmpty() || $reviews->isNotEmpty()): ?>
        <?php echo $__env->make(EcommerceHelper::viewPath('customers.product-reviews.icons'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="product-reviews-page">
            <ul class="nav nav-tabs nav-fill" role="tablist">
                <li class="nav-item" role="presentation">
                    <button
                        class="nav-link <?php if(!request()->has('page')): ?> active <?php endif; ?>"
                        id="waiting-tab"
                        data-toggle="tab"
                        data-target="#waiting-tab-pane"
                        data-bs-toggle="tab"
                        data-bs-target="#waiting-tab-pane"
                        type="button"
                        role="tab"
                        aria-controls="waiting-tab-pane"
                        aria-selected="true"
                    >
                        <?php echo e(__('Waiting for your review')); ?> (<?php echo e($products->count()); ?>)
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button
                        class="nav-link <?php if(request()->has('page')): ?> active <?php endif; ?>"
                        id="reviewed-tab"
                        data-toggle="tab"
                        data-target="#reviewed-tab-pane"
                        data-bs-toggle="tab"
                        data-bs-target="#reviewed-tab-pane"
                        type="button"
                        role="tab"
                        aria-controls="reviewed-tab-pane"
                        aria-selected="false"
                    >
                        <?php echo e(__('Reviewed')); ?> (<?php echo e($reviews->total()); ?>)
                    </button>
                </li>
            </ul>

            <div class="tab-content pt-3">
                <div class="tab-pane fade <?php if(!request()->has('page')): ?> show active <?php endif; ?>" id="waiting-tab-pane" role="tabpanel" aria-labelledby="waiting-tab" tabindex="0">
                    <?php if($products->isNotEmpty()): ?>
                        <div class="row row-cols-md-2 row-cols-1 g-3">
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <div class="ecommerce-product-item border p-3" data-id="<?php echo e($product->id); ?>">
                                        <div class="d-flex gap-2">
                                            <?php echo e(RvMedia::image($product->order_product_image ?: $product->image, $product->name, 'thumb', true, ['class' => 'img-fluid rounded-start ecommerce-product-image'])); ?>


                                            <div>
                                                <a href="<?php echo e($product->url); ?>">
                                                    <h6 class="card-title ecommerce-product-name">
                                                        <?php echo BaseHelper::clean($product->order_product_name ?: $product->name); ?>

                                                    </h6>
                                                </a>

                                                <?php if($product->order_completed_at): ?>
                                                    <div class="text-muted mt-1">
                                                        <?php echo e(__('Order completed at')); ?>:
                                                        <time><?php echo e(Carbon\Carbon::parse($product->order_completed_at)->translatedFormat('M d, Y h:m')); ?></time>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="d-flex ecommerce-product-star mt-1 w-50">
                                                    <?php for($i = 5; $i >= 1; $i--): ?>
                                                        <label class="order-<?php echo e($i); ?>">
                                                            <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-star-filled'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'ecommerce-icon','data-star' => ''.e($i).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                                        </label>
                                                    <?php endfor; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div role="alert" class="alert alert-info"><?php echo e(__('You do not have any products to review yet. Just shopping!')); ?></div>
                    <?php endif; ?>
                </div>

                <div class="tab-pane fade <?php if(request()->has('page')): ?> show active <?php endif; ?>" id="reviewed-tab-pane" role="tabpanel" aria-labelledby="reviewed-tab" tabindex="0">
                    <?php echo $__env->make(EcommerceHelper::viewPath('customers.product-reviews.reviewed'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

            <?php echo $__env->make(EcommerceHelper::viewPath('customers.product-reviews.modal'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php else: ?>
        <?php echo $__env->make(EcommerceHelper::viewPath('customers.partials.empty-state'), [
            'title' => __('No reviews yet!'),
            'subtitle' => __('You have not reviewed any products yet.'),
            'actionUrl' => route('public.products'),
            'actionLabel' => __('Start shopping now'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(EcommerceHelper::viewPath('customers.master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/janahcosmeticsco/public_html/platform/plugins/ecommerce/resources/views/themes/customers/product-reviews/list.blade.php ENDPATH**/ ?>