<?php $__env->startSection('title', __('Order Return Requests')); ?>

<?php $__env->startSection('content'); ?>
    <?php if($requests->isNotEmpty()): ?>
        <div class="table-responsive customer-list-order">
            <table class="table table-bordered table-striped">
                <thead>
                <tr>
                    <th><?php echo e(__('ID number')); ?></th>
                    <th><?php echo e(__('Order ID number')); ?></th>
                    <th><?php echo e(__('Items Count')); ?></th>
                    <th><?php echo e(__('Date')); ?></th>
                    <th><?php echo e(__('Status')); ?></th>
                    <th><?php echo e(__('Actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item->code); ?></td>
                        <td><a
                                href="<?php echo e(route('customer.orders.view', $item->order_id)); ?>"
                                title="Click to show detail"
                            ><?php echo e($item->order->code); ?></a></td>
                        <td><?php echo e($item->items_count); ?></td>
                        <td><?php echo e($item->created_at->translatedFormat('M d, Y h:m')); ?></td>
                        <td><?php echo BaseHelper::clean($item->return_status->toHtml()); ?></td>
                        <td>
                            <a
                                class="btn btn-primary btn-sm"
                                href="<?php echo e(route('customer.order_returns.detail', $item->id)); ?>"
                            ><?php echo e(__('View')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <?php echo $requests->links(); ?>

        </div>
    <?php else: ?>
        <?php echo $__env->make(EcommerceHelper::viewPath('customers.partials.empty-state'), [
            'title' => __('No order return requests yet!'),
            'subtitle' => __('You have not placed any order return requests yet.'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(EcommerceHelper::viewPath('customers.master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/janahcosmeticsco/public_html/platform/plugins/ecommerce/resources/views/themes/customers/order-returns/list.blade.php ENDPATH**/ ?>