<?php $__env->startSection('title', __('Orders')); ?>

<?php $__env->startSection('content'); ?>
    <?php if($orders->isNotEmpty()): ?>
        <div class="table-responsive customer-list-order">
            <table class="table table-bordered table-striped">
                <thead>
                <tr>
                    <th><?php echo e(__('Order number')); ?></th>
                    <th><?php echo e(__('Created at')); ?></th>
                    <th><?php echo e(__('Total')); ?></th>
                    <th><?php echo e(__('Payment method')); ?></th>
                    <th><?php echo e(__('Status')); ?></th>
                    <th><?php echo e(__('Actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($order->code); ?></td>
                        <td><?php echo e($order->created_at->format('d M Y H:i:s')); ?></td>
                        <td><?php echo e(__(':price for :total item(s)', ['price' => $order->amount_format, 'total' => $order->products_count])); ?></td>
                        <td>
                            <?php if(is_plugin_active('payment') && $order->payment->id && $order->payment->payment_channel->label()): ?>
                                <?php echo e($order->payment->payment_channel->label()); ?>

                            <?php else: ?>
                                &mdash;
                            <?php endif; ?>
                        </td>

                        <td><?php echo BaseHelper::clean($order->status->toHtml()); ?></td>

                        <td>
                            <a
                                class="btn btn-primary btn-sm"
                                href="<?php echo e(route('customer.orders.view', $order->id)); ?>"
                            ><?php echo e(__('View')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <?php echo $orders->links(); ?>

        </div>
    <?php else: ?>
        <?php echo $__env->make(EcommerceHelper::viewPath('customers.partials.empty-state'), [
            'title' => __('No orders yet!'),
            'subtitle' => __('You have not placed any orders yet.'),
            'actionUrl' => route('public.products'),
            'actionLabel' => __('Start shopping now'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(EcommerceHelper::viewPath('customers.master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/janahcosmeticsco/public_html/platform/plugins/ecommerce/resources/views/themes/customers/orders/list.blade.php ENDPATH**/ ?>