<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', __('Stores'));
?>

<div class="tp-page-area pt-30 pb-120">
    <div class="container">
        <div class="tp-shop-top mb-45">
            <div class="tp-shop-top-left d-flex flex-wrap gap-3 justify-content-between align-items-center">
                <div class="tp-shop-top-result">
                    <p><?php echo e(__('Showing :from-:to of :total stores', ['from' => $stores->firstItem(), 'to' => $stores->lastItem(), 'total' => $stores->total()])); ?></p>
                </div>

                <?php if (isset($component)) { $__componentOriginald83dae5750a07af1a413e54a0071b325 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald83dae5750a07af1a413e54a0071b325 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'a74ad8dfacd4f985eb3977517615ce25::form.index','data' => ['url' => route('public.stores'),'method' => 'get']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('public.stores')),'method' => 'get']); ?>
                    <div class="tp-sidebar-search-input">
                        <input type="search" name="q" placeholder="<?php echo e(__('Search...')); ?>" value="<?php echo e(BaseHelper::stringify(old('q', request()->query('q')))); ?>">
                        <button type="submit" title="Search">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8.11111 15.2222C12.0385 15.2222 15.2222 12.0385 15.2222 8.11111C15.2222 4.18375 12.0385 1 8.11111 1C4.18375 1 1 4.18375 1 8.11111C1 12.0385 4.18375 15.2222 8.11111 15.2222Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M16.9995 17L13.1328 13.1333" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </button>
                    </div>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $attributes = $__attributesOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__attributesOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $component = $__componentOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__componentOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
            </div>
        </div>

        <?php echo apply_filters('ads_render', null, 'listing_page_before'); ?>


        <div class="row g-4 mb-40">
            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $coverImage = $store->getMetaData('background', true);
                ?>

                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                    <?php echo $__env->make('plugins/marketplace::themes.includes.store-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php echo apply_filters('ads_render', null, 'listing_page_after'); ?>


        <?php echo e($stores->withQueryString()->links(Theme::getThemeNamespace('partials.pagination'))); ?>

    </div>
</div>
<?php /**PATH /home/oday666655/public_html/janahcosmetics.com/platform/themes/shofy/views/marketplace/stores.blade.php ENDPATH**/ ?>