<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', __('Shopping Cart'));
?>

<section class="tp-cart-area pb-120 <?php if(! theme_option('theme_breadcrumb_enabled', true)): ?> pt-50 <?php endif; ?>">
    <div class="container">
        <?php if($products->isNotEmpty()): ?>
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <?php if (isset($component)) { $__componentOriginald83dae5750a07af1a413e54a0071b325 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald83dae5750a07af1a413e54a0071b325 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'a74ad8dfacd4f985eb3977517615ce25::form.index','data' => ['method' => 'post','url' => route('public.cart.update'),'class' => 'cart-form']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['method' => 'post','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('public.cart.update')),'class' => 'cart-form']); ?>
                        <div class="tp-cart-list mb-25 mr-30 bb-ecommerce-table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="tp-cart-header-product"><?php echo e(__('Product')); ?></th>
                                        <th class="tp-cart-header-price"><?php echo e(__('Price')); ?></th>
                                        <th class="tp-cart-header-quantity"><?php echo e(__('Quantity')); ?></th>
                                        <th class="tp-cart-header-total"><?php echo e(__('Total')); ?></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = Cart::instance('cart')->content(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $product = $products->find($cartItem->id);
                                        ?>

                                        <?php if(empty($product)) continue; ?>

                                        <tr>
                                            <td class="ps-3 cart-product-content">
                                                <?php echo apply_filters('ecommerce_cart_before_item_content', null, $cartItem); ?>


                                                <a href="<?php echo e($product->original_product->url); ?>">
                                                    <?php echo e(RvMedia::image($cartItem->options['image'], $product->original_product->name, 'thumb')); ?>

                                                </a>
                                                <div class="tp-cart-title">
                                                    <input type="hidden" name="items[<?php echo e($key); ?>][rowId]" value="<?php echo e($cartItem->rowId); ?>">
                                                    <a href="<?php echo e($product->original_product->url); ?>" class="ms-0"><?php echo e($product->original_product->name); ?></a>
                                                    <div class="small">
                                                        <?php echo $product->stock_status_html; ?>

                                                    </div>

                                                    <?php if(is_plugin_active('marketplace') && $product->original_product->store->id): ?>
                                                        <div class="small">
                                                            <span><?php echo e(__('Vendor:')); ?></span>
                                                            <a href="<?php echo e($product->original_product->store->url); ?>" class="small fw-medium"><?php echo e($product->original_product->store->name); ?></a>
                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="small"><?php echo e($cartItem->options['attributes'] ?? ''); ?></div>

                                                    <?php if(EcommerceHelper::isEnabledProductOptions() && !empty($cartItem->options['options'])): ?>
                                                        <?php echo render_product_options_html($cartItem->options['options'], $product->price()->getPrice()); ?>

                                                    <?php endif; ?>

                                                    <?php echo $__env->make(
                                                        EcommerceHelper::viewPath('includes.cart-item-options-extras'),
                                                        ['options' => $cartItem->options]
                                                    , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                                    <?php echo apply_filters('ecommerce_cart_after_item_content', null, $cartItem); ?>

                                                </div>
                                            </td>
                                            <td class="tp-cart-price" data-title="<?php echo e(__('Price')); ?>">
                                                <?php echo $__env->make(EcommerceHelper::viewPath('includes.product-price'), [
                                                    'priceWrapperClassName' => '',
                                                    'priceClassName' => '',
                                                    'priceOriginalWrapperClassName' => '',
                                                    'priceOriginalClassName' => 'text-muted',
                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </td>
                                            <td class="tp-cart-quantity" data-title="<?php echo e(__('Quantity')); ?>">
                                                <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.cart-quantity'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </td>
                                            <td class="tp-cart-total" data-title="<?php echo e(__('Total')); ?>">
                                                <?php echo e(format_price($cartItem->price * $cartItem->qty)); ?>

                                            </td>
                                            <td class="tp-cart-action" data-title="<?php echo e(__('Remove')); ?>">
                                                <button
                                                    class="tp-cart-action-btn"
                                                    data-url="<?php echo e(route('public.cart.remove', $cartItem->rowId)); ?>"
                                                    data-bb-toggle="remove-from-cart"
                                                    <?php echo EcommerceHelper::jsAttributes('remove-from-cart', $product, ['data-product-quantity' => $cartItem->qty]); ?>

                                                >
                                                    <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-trash'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $attributes = $__attributesOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__attributesOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $component = $__componentOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__componentOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
                    <div class="tp-cart-bottom">
                        <div class="tp-cart-coupon">
                            <?php if (isset($component)) { $__componentOriginald83dae5750a07af1a413e54a0071b325 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald83dae5750a07af1a413e54a0071b325 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'a74ad8dfacd4f985eb3977517615ce25::form.index','data' => ['url' => route('public.coupon.apply'),'method' => 'post','id' => 'coupon-form']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('public.coupon.apply')),'method' => 'post','id' => 'coupon-form']); ?>
                                <div class="tp-cart-coupon-input-box">
                                    <label><?php echo e(__('Coupon Code:')); ?></label>
                                    <div class="tp-cart-coupon-input d-flex align-items-center">
                                        <input type="text" placeholder="<?php echo e(__('Enter Coupon Code')); ?>" name="coupon_code" value="<?php echo e(BaseHelper::stringify(old('coupon_code', session('applied_coupon_code')))); ?>" />
                                        <button type="submit" <?php if(session('applied_coupon_code')): echo 'disabled'; endif; ?>><?php echo e(__('Apply')); ?></button>
                                    </div>
                                </div>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $attributes = $__attributesOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__attributesOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald83dae5750a07af1a413e54a0071b325)): ?>
<?php $component = $__componentOriginald83dae5750a07af1a413e54a0071b325; ?>
<?php unset($__componentOriginald83dae5750a07af1a413e54a0071b325); ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="tp-cart-checkout-wrapper">
                        <div class="tp-cart-checkout-top d-flex align-items-center justify-content-between">
                            <span class="tp-cart-checkout-top-title"><?php echo e(__('Subtotal')); ?></span>
                            <span class="tp-cart-checkout-top-price"><?php echo e(format_price(Cart::instance('cart')->rawSubTotal())); ?></span>
                        </div>
                        <?php if(EcommerceHelper::isTaxEnabled()): ?>
                            <div class="tp-cart-checkout-tax d-flex align-items-center justify-content-between mb-2">
                                <span class="tp-cart-checkout-tax-title"><?php echo e(__('Tax')); ?></span>
                                <span class="tp-cart-checkout-tax-price"><?php echo e(format_price(Cart::instance('cart')->rawTax())); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if($couponDiscountAmount > 0 && session('applied_coupon_code')): ?>
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <div>
                                    <?php echo e(__('Coupon')); ?>

                                    <span class="small">(<?php echo e(session('applied_coupon_code')); ?>)</span>
                                    <a class="small btn-link text-danger lh-1" data-bb-toggle="remove-coupon" href="<?php echo e(route('public.coupon.remove')); ?>"><?php echo e(__('Remove')); ?></a>
                                </div>
                                <span><?php echo e(format_price($couponDiscountAmount)); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if($promotionDiscountAmount): ?>
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <span><?php echo e(__('Promotion')); ?></span>
                                <span><?php echo e(format_price($promotionDiscountAmount)); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="tp-cart-checkout-total d-flex align-items-center justify-content-between mt-3 mb-0">
                            <span><?php echo e(__('Total')); ?></span>
                            <span><?php echo e(($promotionDiscountAmount + $couponDiscountAmount) > Cart::instance('cart')->rawTotal() ? format_price(0) : format_price(Cart::instance('cart')->rawTotal() - $promotionDiscountAmount - $couponDiscountAmount)); ?></span>
                        </div>
                        <p class="small"><?php echo e(__('(Shipping fees not included)')); ?></p>
                        <div class="tp-cart-checkout-proceed">
                            <a href="<?php echo e(route('public.checkout.information', OrderHelper::getOrderSessionToken())); ?>" class="tp-cart-checkout-btn w-100">
                                <?php echo e(__('Proceed to Checkout')); ?>

                            </a>
                        </div>

                        <a href="<?php echo e(route('public.products')); ?>" class="btn-link d-block text-center mt-3">
                            <?php echo e(__('Continue Shopping')); ?>

                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="text-center pt-50">
                <h3><?php echo e(__('Your cart is empty')); ?></h3>
                <a href="<?php echo e(route('public.products')); ?>" class="tp-cart-checkout-btn mt-20"><?php echo e(__('Continue Shopping')); ?></a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php /**PATH /home/jeffacomputersco/dev.jeffacomputers.com/platform/themes/shofy/views/ecommerce/cart.blade.php ENDPATH**/ ?>