<?php
    $title = $shortcode->title;
    $subtitle = $shortcode->subtitle;
?>

<section class="tp-product-area position-relative pb-30 pt-30">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-6 col-lg-6">
                <?php echo Theme::partial('section-title', compact('shortcode')); ?>

            </div>
            <div class="col-xl-6 col-lg-6">
                <div class="tp-product-tab-2 tp-product-tab-3 tp-tab mb-50 text-center">
                    <div class="tp-product-tab-inner-3 d-flex align-items-center justify-content-center justify-content-lg-end">
                        <nav>
                            <div
                                class="nav nav-tabs justify-content-center tp-product-tab tp-tab-menu p-relative"
                                id="productTab"
                                role="tablist"
                                data-ajax-url="<?php echo e(route('public.ajax.products', ['limit' => $shortcode->limit ?: 8])); ?>"
                            >
                                <?php $__currentLoopData = $productTabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(! in_array($key, $selectedTabs) || (! EcommerceHelper::isReviewEnabled() && $key === 'top-rated')) continue; ?>

                                    <button
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active' => $loop->first]); ?>"
                                        id="<?php echo e($key); ?>-tab"
                                        data-bs-toggle="tab"
                                        data-bs-target="#tab-pane"
                                        type="button"
                                        role="tab"
                                        aria-controls="tab-pane"
                                        <?php if($loop->first): ?> aria-selected="true" <?php endif; ?>
                                        data-bb-toggle="product-tab"
                                        data-bb-value="<?php echo e($key); ?>"
                                    >
                                        <?php echo e($tab); ?>

                                        <span class="tp-product-tab-tooltip">0</span>
                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <span id="productTabMarker" class="tp-tab-line d-none d-sm-inline-block"></span>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="tab-content" id="productTabContent">
                    <div class="tab-pane fade show active" id="tab-pane" role="tabpanel" aria-labelledby="tab" tabindex="0">
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(! isset($tab['products'])) continue; ?>

                            <?php echo $__env->make(
                                Theme::getThemeNamespace('views.ecommerce.includes.product-items'),
                                ['products' => $tab['products'], 'itemsPerRow' => get_products_per_row(), 'layout' => 'grid']
                            , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\laragon\www\Jeffa\platform\themes/shofy-beauty/partials/shortcodes/ecommerce-product-groups/tabs.blade.php ENDPATH**/ ?>