<?php
    Theme::layout('full-width');
    Theme::set('pageTitle', __('Galleries'));
?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['pb-100', 'pt-50' => ! theme_option('theme_breadcrumb_enabled', true)]); ?>">
    <?php echo apply_filters('ads_render', null, 'listing_page_before'); ?>


    <div class="container">
        <?php if(isset($galleries) && $galleries->isNotEmpty()): ?>
            <div class="row row-cols-4 g-3">
                <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col">
                        <div class="tp-instagram-item p-relative z-index-1 fix mb-30 w-img">
                            <?php echo e(RvMedia::image($gallery->image, $gallery->name, 'medium')); ?>

                            <div class="tp-instagram-icon">
                                <a href="<?php echo e($gallery->url); ?>">
                                    <?php echo e($gallery->name); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center">
                <h3><?php echo e(__('No galleries found')); ?></h3>
            </div>
        <?php endif; ?>

        <?php echo apply_filters('ads_render', null, 'listing_page_after'); ?>

    </div>
</section>
<?php /**PATH /home/janahcosmetico/public_html/platform/themes/shofy/views/galleries.blade.php ENDPATH**/ ?>